//
// Lunar Eclipse Elements by Fred Espenak and Jean Meeus, April 2007
//
function LE2001( latitude, longitude, altitude ) {
    return calculateforLunar( latitude, longitude, altitude, new Array(
                           "  2001 to   2100",
                           // 2001  1  9
                           2451919.348374,  20.0,    64.1, " 2.162", " 1.189",  1,
                           3.29475,  1.02253,  0.27861,
                           -2.23117, -1.27481, -0.14757,  0.36098,  0.86973,  1.99702,  2.95278,
                           111.0355098,   0.68656, -7.300e-05,
                           22.3913306,  -0.03239, -1.453e-03,
                           // 2001  7  5
                           2452096.122488,  15.0,    64.2, " 1.548", " 0.495",  2,
                           9.91170,  0.91401,  0.24905,
                           -2.76926, -1.38831,  0.00000, -0.06028,  0.00000,  1.26616,  2.64889,
                           284.8526295,   0.55502, -1.740e-04,
                           -23.4052500,   0.00545,  9.790e-04,
                           // 2001 12 30
                           2452273.937759,  11.0,    64.3, " 0.893", "-0.116",  3,
                           17.59710,  0.98618,  0.26871,
                           -2.52237,  0.00000,  0.00000, -0.49380,  0.00000,  0.00000,  1.53644,
                           99.8527280,   0.64957,  3.260e-04,
                           24.2119414,   0.01299, -1.373e-03,
                           // 2002  5 26
                           2452421.003078,  12.0,    64.3, " 0.689", "-0.289",  3,
                           4.25918,  0.98735,  0.26903,
                           -1.73212,  0.00000,  0.00000,  0.07387,  0.00000,  0.00000,  1.87724,
                           243.4219588,   0.60906,  3.650e-04,
                           -20.0149302,  -0.15750,  1.103e-03,
                           // 2002  6 24
                           2452450.394598,  21.0,    64.3, " 0.209", "-0.792",  3,
                           15.18941,  0.96066,  0.26176,
                           -0.60766,  0.00000,  0.00000,  0.47036,  0.00000,  0.00000,  1.54363,
                           273.0671928,   0.61813, -7.900e-05,
                           -24.7671299,  -0.03788,  1.286e-03,
                           // 2002 11 20
                           2452598.574767,   2.0,    64.4, " 0.860", "-0.226",  3,
                           5.92815,  0.91136,  0.24832,
                           -2.40771,  0.00000,  0.00000, -0.20559,  0.00000,  0.00000,  1.99738,
                           55.7306417,   0.50843,  5.980e-04,
                           18.6866889,   0.15766, -6.450e-04,
                           // 2003  5 16
                           2452775.653624,   4.0,    64.4, " 2.075", " 1.128",  1,
                           19.56427,  1.02171,  0.27839,
                           -2.86738, -1.92892, -0.74155, -0.31302,  0.11532,  1.30252,  2.24126,
                           232.8771849,   0.63258,  7.030e-04,
                           -18.6574591,  -0.20832,  1.082e-03,
                           // 2003 11  9
                           2452952.555301,   1.0,    64.5, " 2.114", " 1.018",  1,
                           4.18669,  0.90100,  0.24550,
                           -2.69910, -1.43478,  0.14401,  0.32721,  0.51017,  2.08876,  3.35361,
                           43.7479593,   0.47844,  4.050e-04,
                           16.2696404,   0.18536, -5.550e-04,
                           // 2004  5  4
                           2453130.355059,  21.0,    64.6, " 2.263", " 1.304",  1,
                           11.87209,  1.01134,  0.27556,
                           -3.10983, -2.17164, -1.10733, -0.47857,  0.15055,  1.21510,  2.15218,
                           222.3920249,   0.60065,  9.000e-04,
                           -16.6531111,  -0.23671,  8.020e-04,
                           // 2004 10 28
                           2453306.628603,   3.0,    64.6, " 2.364", " 1.308",  1,
                           5.45344,  0.93289,  0.25419,
                           -2.86061, -1.73615, -0.58444,  0.08648,  0.75686,  1.90841,  3.03548,
                           32.5931505,   0.49518,  2.730e-04,
                           13.4222694,   0.22312, -5.680e-04,
                           // 2005  4 24
                           2453484.913835,  10.0,    64.8, " 0.865", "-0.144",  3,
                           0.16896,  0.96437,  0.26277,
                           -2.11379,  0.00000,  0.00000, -0.06796,  0.00000,  0.00000,  1.98030,
                           211.6323732,   0.52938,  7.780e-04,
                           -13.9254307,  -0.23916,  4.680e-04,
                           // 2005 10 17
                           2453661.003094,  12.0,    64.9, " 1.058", " 0.062",  2,
                           13.73936,  0.98574,  0.26859,
                           -2.09103, -0.39374,  0.00000,  0.07427,  0.00000,  0.53911,  2.23912,
                           21.9362112,   0.53656,  2.360e-04,
                           10.2305101,   0.26721, -5.470e-04,
                           // 2006  3 14
                           2453809.492063,   0.0,    65.1, " 1.030", "-0.060",  3,
                           11.49727,  0.90230,  0.24585,
                           -2.58608,  0.00000,  0.00000, -0.19050,  0.00000,  0.00000,  2.20484,
                           175.2556190,   0.43684, -4.000e-05,
                           3.0431199,  -0.23745, -1.200e-04,
                           // 2006  9  7
                           2453986.286395,  19.0,    65.3, " 1.133", " 0.184",  2,
                           18.11422,  1.02286,  0.27870,
                           -2.24659, -0.88534,  0.00000, -0.12652,  0.00000,  0.63272,  1.99311,
                           346.7196088,   0.56551, -3.030e-04,
                           -6.7027302,   0.29840,  3.470e-04,
                           // 2007  3  3
                           2454163.473596,  23.0,    65.5, " 2.319", " 1.233",  1,
                           9.75581,  0.90863,  0.24758,
                           -2.67864, -1.47627, -0.24515,  0.36630,  0.97738,  2.20825,  3.41185,
                           164.3031511,   0.44898, -3.240e-04,
                           7.0196100,  -0.23493, -1.630e-04,
                           // 2007  8 28
                           2454340.943366,  11.0,    65.7, " 2.453", " 1.476",  1,
                           9.41931,  0.99145,  0.27015,
                           -3.08722, -2.12725, -1.10917, -0.35922,  0.39110,  1.40930,  2.36728,
                           336.9050914,   0.54256, -2.350e-04,
                           -9.8584500,   0.26933,  5.370e-04,
                           // 2008  2 21
                           2454517.643852,   3.0,    65.9, " 2.145", " 1.106",  1,
                           13.02804,  0.95235,  0.25949,
                           -2.37137, -1.26004,  0.03739,  0.45245,  0.86669,  2.16401,  3.27800,
                           153.4734354,   0.50532, -6.140e-04,
                           10.5790298,  -0.24351, -2.990e-04,
                           // 2008  8 16
                           2454695.382779,  21.0,    66.1, " 1.837", " 0.808",  2,
                           18.70796,  0.93904,  0.25587,
                           -2.56770, -1.38021,  0.00000,  0.18670,  0.00000,  1.75529,  2.94078,
                           326.3307018,   0.50159, -2.510e-04,
                           -12.9665404,   0.22362,  5.690e-04,
                           // 2009  2  9
                           2454872.110672,  15.0,    66.3, " 0.899", "-0.088",  3,
                           0.32217,  1.00393,  0.27355,
                           -2.33426,  0.00000,  0.00000, -0.34388,  0.00000,  0.00000,  1.64580,
                           143.1240596,   0.57722, -7.830e-04,
                           13.4422195,  -0.24673, -5.760e-04,
                           // 2009  7  7
                           2455019.902577,  10.0,    66.5, " 0.156", "-0.913",  3,
                           5.03354,  0.89981,  0.24518,
                           -1.35083,  0.00000,  0.00000, -0.33815,  0.00000,  0.00000,  0.67400,
                           287.2121047,   0.52814, -4.310e-04,
                           -23.8263704,   0.10151,  8.970e-04,
                           // 2009  8  6
                           2455049.527985,   1.0,    66.5, " 0.402", "-0.666",  3,
                           21.98019,  0.90317,  0.24609,
                           -1.90907,  0.00000,  0.00000, -0.32836,  0.00000,  0.00000,  1.25409,
                           315.8506234,   0.47964, -3.610e-04,
                           -15.5153297,   0.18407,  5.420e-04,
                           // 2009 12 31
                           2455197.308170,  19.0,    66.7, " 1.056", " 0.076",  2,
                           1.68882,  1.01599,  0.27683,
                           -1.69585, -0.10290,  0.00000,  0.39607,  0.00000,  0.89668,  2.48832,
                           101.0748605,   0.67784, -3.960e-04,
                           24.0611394,  -0.10439, -1.517e-03,
                           // 2010  6 26
                           2455373.985811,  12.0,    66.9, " 1.577", " 0.537",  2,
                           6.30029,  0.92490,  0.25201,
                           -3.02475, -1.69865,  0.00000, -0.34054,  0.00000,  1.01566,  2.34374,
                           275.4918553,   0.56594, -4.900e-04,
                           -23.9790900,   0.06737,  1.015e-03,
                           // 2010 12 21
                           2455551.845882,   8.0,    67.1, " 2.281", " 1.256",  1,
                           13.98569,  0.97062,  0.26447,
                           -2.49226, -1.43745, -0.30142,  0.30116,  0.90436,  2.04061,  3.09303,
                           89.1339755,   0.62484,  3.100e-05,
                           23.7615793,  -0.04933, -1.278e-03,
                           // 2011  6 15
                           2455728.342864,  20.0,    67.3, " 2.687", " 1.700",  1,
                           13.58347,  0.97584,  0.26589,
                           -2.57108, -1.59890, -0.60649,  0.22874,  1.06364,  2.05582,  3.03019,
                           263.7402416,   0.63054, -4.020e-04,
                           -23.2375296,   0.02828,  1.246e-03,
                           // 2011 12 10
                           2455906.106209,  15.0,    67.5, " 2.186", " 1.106",  1,
                           20.26613,  0.91992,  0.25066,
                           -3.42120, -2.21928, -0.87674, -0.45098, -0.02458,  1.31818,  2.51806,
                           77.3934336,   0.55919,  1.620e-04,
                           22.5526904,  -0.00268, -9.670e-04,
                           // 2012  6  4
                           2456082.961344,  11.0,    67.7, " 1.318", " 0.370",  2,
                           3.88582,  1.01729,  0.27719,
                           -2.17816, -0.98314,  0.00000,  0.07225,  0.00000,  1.12657,  2.32242,
                           252.8579471,   0.67679, -5.400e-05,
                           -21.6644397,  -0.01656,  1.374e-03,
                           // 2012 11 28
                           2456260.107026,  15.0,    68.0, " 0.915", "-0.187",  3,
                           19.52741,  0.89937,  0.24506,
                           -2.73136,  0.00000,  0.00000, -0.43137,  0.00000,  0.00000,  1.86850,
                           65.2309499,   0.52522,  1.230e-04,
                           20.4789015,   0.03784, -7.890e-04,
                           // 2013  4 25
                           2456408.339323,  20.0,    68.2, " 0.987", " 0.015",  2,
                           10.26615,  1.00045,  0.27260,
                           -1.91977, -0.07987,  0.00000,  0.14376,  0.00000,  0.37017,  2.20869,
                           213.1265591,   0.60938,  6.210e-04,
                           -14.4045889,  -0.15016,  7.300e-04,
                           // 2013  5 25
                           2456437.674374,   4.0,    68.2, " 0.016", "-0.934",  3,
                           20.19364,  1.01763,  0.27728,
                           -0.09367,  0.00000,  0.00000,  0.18497,  0.00000,  0.00000,  0.46583,
                           242.1681273,   0.66420,  3.830e-04,
                           -19.4011301,  -0.06219,  1.193e-03,
                           // 2013 10 18
                           2456584.494043,   0.0,    68.4, " 0.765", "-0.272",  3,
                           1.84204,  0.94742,  0.25815,
                           -2.13642,  0.00000,  0.00000, -0.14296,  0.00000,  0.00000,  1.84858,
                           23.6581309,   0.53536,  5.500e-05,
                           11.0252504,   0.15271, -5.340e-04,
                           // 2014  4 15
                           2456762.824162,   8.0,    68.6, " 2.318", " 1.291",  1,
                           21.56029,  0.94901,  0.25858,
                           -3.08663, -2.00891, -0.86816, -0.22012,  0.42855,  1.56962,  2.64493,
                           203.4560084,   0.53583,  4.790e-04,
                           -10.0835398,  -0.15248,  3.680e-04,
                           // 2014 10  8
                           2456938.955370,  11.0,    68.9, " 2.146", " 1.166",  1,
                           12.13343,  0.99942,  0.27232,
                           -2.72095, -1.73411, -0.56165, -0.07112,  0.41883,  1.59119,  2.57996,
                           13.8214795,   0.58348,  0.000e-00,
                           6.3204099,   0.18219, -3.890e-04,
                           // 2015  4  4
                           2457117.000967,  12.0,    69.1, " 2.079", " 1.001",  1,
                           0.83252,  0.90720,  0.24719,
                           -2.95673, -1.71821, -0.01576,  0.02321,  0.06272,  1.76522,  3.00207,
                           193.3626964,   0.48085,  2.150e-04,
                           -5.2854501,  -0.15081,  1.540e-04,
                           // 2015  9 28
                           2457293.616861,   3.0,    69.3, " 2.230", " 1.276",  1,
                           3.43851,  1.02405,  0.27903,
                           -2.78438, -1.86096, -0.79460, -0.19533,  0.40390,  1.47017,  2.39355,
                           4.5082403,   0.60623,  5.000e-05,
                           1.5729700,   0.19768, -9.000e-05,
                           // 2016  3 23
                           2457470.991914,  12.0,    69.6, " 0.775", "-0.312",  3,
                           0.09379,  0.90323,  0.24611,
                           -2.32271,  0.00000,  0.00000, -0.19408,  0.00000,  0.00000,  1.93327,
                           183.4190201,   0.47269, -6.000e-05,
                           -0.3361200,  -0.15555,  3.300e-05,
                           // 2016  9 16
                           2457648.288503,  19.0,    69.8, " 0.908", "-0.064",  3,
                           18.74360,  1.00187,  0.27298,
                           -2.06942,  0.00000,  0.00000, -0.07594,  0.00000,  0.00000,  1.91843,
                           355.1579523,   0.58126,  8.700e-05,
                           -3.2456901,   0.19057,  2.320e-04,
                           // 2017  2 11
                           2457795.531284,   1.0,    70.0, " 0.988", "-0.035",  3,
                           10.41937,  0.96823,  0.26382,
                           -2.40940,  0.00000,  0.00000, -0.24918,  0.00000,  0.00000,  1.90991,
                           144.7362028,   0.56945, -5.570e-04,
                           13.0189698,  -0.13593, -5.620e-04,
                           // 2017  8  7
                           2457973.265023,  18.0,    70.3, " 1.289", " 0.246",  2,
                           15.09655,  0.92574,  0.25224,
                           -2.14646, -0.59847,  0.00000,  0.36055,  0.00000,  1.32219,  2.86829,
                           317.5301123,   0.53049, -9.100e-05,
                           -15.4601810,   0.10725,  6.680e-04,
                           // 2018  1 31
                           2458150.063195,  14.0,    70.5, " 2.294", " 1.315",  1,
                           22.71624,  1.01459,  0.27645,
                           -3.12629, -2.17293, -1.11740, -0.48331,  0.15049,  1.20594,  2.16050,
                           134.3315707,   0.64268, -5.610e-04,
                           16.9388896,  -0.11778, -9.750e-04,
                           // 2018  7 27
                           2458327.349240,  20.0,    70.8, " 2.679", " 1.609",  1,
                           16.36331,  0.89992,  0.24521,
                           -2.73331, -1.57272, -0.47616,  0.38175,  1.23969,  2.33630,  3.49665,
                           306.8788694,   0.51650, -2.060e-04,
                           -18.9976299,   0.07311,  7.190e-04,
                           // 2019  1 21
                           2458504.717674,   5.0,    71.0, " 2.168", " 1.195",  1,
                           13.01859,  1.02164,  0.27837,
                           -2.37188, -1.41529, -0.29228,  0.22418,  0.74086,  1.86390,  2.81976,
                           122.9689909,   0.67148, -2.500e-04,
                           20.3549097,  -0.07966, -1.295e-03,
                           // 2019  7 16
                           2458681.397162,  22.0,    71.3, " 1.704", " 0.653",  2,
                           17.63006,  0.91617,  0.24964,
                           -3.24893, -1.95166,  0.00000, -0.46811,  0.00000,  1.01400,  2.31310,
                           296.2585537,   0.54932, -3.260e-04,
                           -21.8611696,   0.04360,  8.980e-04,
                           // 2020  1 10
                           2458859.299431,  19.0,    71.6, " 0.896", "-0.116",  3,
                           2.31820,  0.98355,  0.26799,
                           -1.85095,  0.00000,  0.00000,  0.18633,  0.00000,  0.00000,  2.22517,
                           111.5716728,   0.63905,  1.040e-04,
                           23.0070397,  -0.03331, -1.297e-03,
                           // 2020  6  5
                           2459006.309881,  19.0,    71.8, " 0.568", "-0.405",  3,
                           11.97754,  0.99031,  0.26983,
                           -1.21606,  0.00000,  0.00000,  0.43716,  0.00000,  0.00000,  2.08750,
                           254.3313828,   0.62902,  2.580e-04,
                           -21.4015901,  -0.11683,  1.218e-03,
                           // 2020  7  5
                           2459035.688332,   5.0,    71.8, " 0.355", "-0.644",  3,
                           23.91051,  0.96399,  0.26266,
                           -1.85707,  0.00000,  0.00000, -0.48002,  0.00000,  0.00000,  0.89297,
                           285.0999097,   0.61967, -3.110e-04,
                           -24.0507199,   0.00848,  1.244e-03,
                           // 2020 11 30
                           2459183.905567,  10.0,    72.0, " 0.829", "-0.262",  3,
                           14.64925,  0.90976,  0.24789,
                           -2.44079,  0.00000,  0.00000, -0.26638,  0.00000,  0.00000,  1.90895,
                           67.3338763,   0.52412,  5.440e-04,
                           20.7787998,   0.12215, -7.660e-04,
                           // 2021  5 26
                           2459360.972137,  11.0,    72.3, " 1.954", " 1.009",  1,
                           3.28263,  1.02237,  0.27857,
                           -2.18575, -1.23068,  0.21037,  0.33129,  0.45204,  1.89293,  2.84819,
                           243.4405369,   0.65440,  6.760e-04,
                           -20.6813296,  -0.16991,  1.249e-03,
                           // 2021 11 19
                           2459537.877844,   9.0,    72.6, " 2.072", " 0.974",  2,
                           12.90779,  0.90168,  0.24569,
                           -2.94399, -1.66849,  0.00000,  0.06825,  0.00000,  1.80448,  3.08064,
                           55.0691925,   0.49810,  4.170e-04,
                           19.1436013,   0.15692, -6.880e-04,
                           // 2022  5 16
                           2459715.675482,   4.0,    72.9, " 2.373", " 1.414",  1,
                           19.59045,  1.00919,  0.27498,
                           -2.44436, -1.51510, -0.49559,  0.21157,  0.91905,  1.93878,  2.86679,
                           232.7346252,   0.61968,  9.490e-04,
                           -19.2848086,  -0.20387,  9.860e-04,
                           // 2022 11  8
                           2459891.958588,  11.0,    73.1, " 2.414", " 1.359",  1,
                           14.17454,  0.93550,  0.25490,
                           -2.94172, -1.82624, -0.70224,  0.00611,  0.71394,  1.83777,  2.95585,
                           43.4474412,   0.51689,  3.480e-04,
                           16.8506402,   0.20047, -7.240e-04,
                           // 2023  5  5
                           2460070.225059,  17.0,    73.4, " 0.964", "-0.046",  3,
                           7.88732,  0.96114,  0.26189,
                           -1.74356,  0.00000,  0.00000,  0.40142,  0.00000,  0.00000,  2.54844,
                           221.8793645,   0.54451,  8.670e-04,
                           -17.1562006,  -0.21449,  6.370e-04,
                           // 2023 10 28
                           2460246.343954,  20.0,    73.7, " 1.118", " 0.122",  2,
                           22.46046,  0.98859,  0.26937,
                           -1.94992, -0.39117,  0.00000,  0.25490,  0.00000,  0.89808,  2.45945,
                           32.3064703,   0.55675,  3.880e-04,
                           14.0201398,   0.25007, -7.350e-04,
                           // 2024  3 25
                           2460394.801379,   7.0,    73.9, " 0.956", "-0.132",  3,
                           19.21563,  0.90150,  0.24564,
                           -2.09301,  0.00000,  0.00000,  0.23311,  0.00000,  0.00000,  2.55901,
                           185.0704506,   0.43558,  8.400e-05,
                           -1.1463000,  -0.23681,  6.000e-06,
                           // 2024  9 18
                           2460571.614869,   3.0,    74.2, " 1.037", " 0.085",  2,
                           2.83532,  1.02233,  0.27856,
                           -2.29558, -0.76599,  0.00000, -0.24313,  0.00000,  0.28039,  1.80897,
                           356.6608945,   0.55843, -7.500e-05,
                           -2.5168701,   0.30406,  1.500e-04,
                           // 2025  3 14
                           2460748.791623,   7.0,    74.5, " 2.260", " 1.178",  1,
                           18.47691,  0.91021,  0.24801,
                           -3.02261, -1.82017, -0.54629, -0.00106,  0.54374,  1.81734,  3.02108,
                           174.5962735,   0.44419, -1.910e-04,
                           2.6815700,  -0.24199, -2.400e-05,
                           // 2025  9  7
                           2460926.259004,  18.0,    74.8, " 2.344", " 1.362",  1,
                           17.13767,  0.98863,  0.26938,
                           -2.50684, -1.52866, -0.46781,  0.21609,  0.90044,  1.96141,  2.93749,
                           346.5540450,   0.52813, -6.400e-05,
                           -6.0629002,   0.27961,  3.670e-04,
                           // 2026  3  3
                           2461102.982548,  12.0,    75.1, " 2.184", " 1.151",  1,
                           22.75188,  0.95519,  0.26027,
                           -3.23982, -2.14568, -0.90522, -0.41886,  0.06675,  1.30709,  2.40387,
                           164.2699291,   0.49497, -4.580e-04,
                           6.2929402,  -0.25912, -1.220e-04,
                           // 2026  8 28
                           2461280.676440,   4.0,    75.4, " 1.965", " 0.930",  2,
                           2.42632,  0.93608,  0.25506,
                           -2.58040, -1.41577,  0.00000,  0.23455,  0.00000,  1.88631,  3.04894,
                           336.4129626,   0.48392, -1.450e-04,
                           -9.3571705,   0.23948,  4.200e-04,
                           // 2027  2 20
                           2461457.468127,  23.0,    75.7, " 0.927", "-0.057",  3,
                           9.04327,  1.00598,  0.27410,
                           -1.77348,  0.00000,  0.00000,  0.23505,  0.00000,  0.00000,  2.24303,
                           153.4670150,   0.56172, -6.340e-04,
                           9.8514098,  -0.27025, -3.790e-04,
                           // 2027  7 18
                           2461605.169544,  16.0,    76.0, " 0.001", "-1.068",  3,
                           11.74916,  0.90017,  0.24528,
                           -0.02964,  0.00000,  0.00000,  0.06905,  0.00000,  0.00000,  0.16686,
                           298.2026441,   0.51376, -5.290e-04,
                           -22.3497792,   0.13548,  8.030e-04,
                           // 2027  8 17
                           2461634.802075,   7.0,    76.0, " 0.546", "-0.525",  3,
                           4.69582,  0.90215,  0.24582,
                           -1.57095,  0.00000,  0.00000,  0.24981,  0.00000,  0.00000,  2.07201,
                           325.8795268,   0.46294, -3.120e-04,
                           -12.4624793,   0.20488,  4.170e-04,
                           // 2028  1 12
                           2461782.676539,   4.0,    76.3, " 1.047", " 0.066",  2,
                           11.41266,  1.01445,  0.27641,
                           -1.85198, -0.22887,  0.00000,  0.23694,  0.00000,  0.70453,  2.32612,
                           113.3149489,   0.65769, -5.800e-04,
                           22.7250007,  -0.15405, -1.383e-03,
                           // 2028  7  6
                           2461959.264549,  18.0,    76.6, " 1.427", " 0.389",  2,
                           13.01592,  0.92761,  0.25275,
                           -2.23964, -0.83109,  0.00000,  0.34918,  0.00000,  1.52711,  2.93762,
                           286.4586802,   0.55960, -6.470e-04,
                           -23.3251489,   0.10636,  9.560e-04,
                           // 2028 12 31
                           2462137.203647,  17.0,    76.9, " 2.274", " 1.246",  1,
                           23.70953,  0.96786,  0.26372,
                           -2.91514, -1.85225, -0.70662, -0.11246,  0.48234,  1.62816,  2.68857,
                           101.6038450,   0.61258, -1.880e-04,
                           23.3160989,  -0.09780, -1.232e-03,
                           // 2029  6 26
                           2462313.641232,   3.0,    77.2, " 2.827", " 1.844",  1,
                           21.30183,  0.97907,  0.26677,
                           -2.40235, -1.44010, -0.45963,  0.38958,  1.23848,  2.21873,  3.18312,
                           275.0152993,   0.63098, -6.160e-04,
                           -23.3642398,   0.07392,  1.234e-03,
                           // 2029 12 20
                           2462491.446665,  23.0,    77.5, " 2.201", " 1.117",  1,
                           4.98723,  0.91793,  0.25012,
                           -3.26363, -2.05698, -0.72696, -0.28005,  0.16748,  1.49772,  2.70244,
                           89.4015755,   0.55670, -2.200e-05,
                           23.0726198,  -0.04518, -9.880e-04,
                           // 2030  6 15
                           2462668.273999,  19.0,    77.8, " 1.448", " 0.502",  2,
                           12.60692,  1.01864,  0.27755,
                           -2.74255, -1.62741,  0.00000, -0.42402,  0.00000,  0.77859,  1.89455,
                           264.4815084,   0.68195, -2.860e-04,
                           -22.5488092,   0.03344,  1.431e-03,
                           // 2030 12  9
                           2462845.436702,  22.0,    78.2, " 0.942", "-0.163",  3,
                           3.24577,  0.89949,  0.24509,
                           -1.84606,  0.00000,  0.00000,  0.48086,  0.00000,  0.00000,  2.80768,
                           76.5739338,   0.53210, -1.400e-05,
                           21.9173291,   0.00081, -8.550e-04,
                           // 2031  5  7
                           2462993.661131,   4.0,    78.4, " 0.881", "-0.090",  3,
                           18.98725,  0.99778,  0.27187,
                           -2.10993,  0.00000,  0.00000, -0.13285,  0.00000,  0.00000,  1.84589,
                           223.8244931,   0.62366,  6.450e-04,
                           -17.8075992,  -0.12082,  9.460e-04,
                           // 2031  6  5
                           2463022.989783,  12.0,    78.5, " 0.129", "-0.820",  3,
                           4.91474,  1.01603,  0.27684,
                           -1.04038,  0.00000,  0.00000, -0.24521,  0.00000,  0.00000,  0.55220,
                           253.5373323,   0.67244,  2.140e-04,
                           -21.0578011,  -0.01560,  1.319e-03,
                           // 2031 10 30
                           2463169.824130,   8.0,    78.8, " 0.716", "-0.320",  3,
                           10.56313,  0.95035,  0.25895,
                           -2.15326,  0.00000,  0.00000, -0.22087,  0.00000,  0.00000,  1.70935,
                           34.2044092,   0.55258,  1.090e-04,
                           14.8610607,   0.13365, -7.180e-04,
                           // 2032  4 25
                           2463348.135308,  15.0,    79.1, " 2.219", " 1.191",  1,
                           5.27865,  0.94595,  0.25775,
                           -2.60682, -1.51198, -0.29838,  0.24739,  0.79390,  2.00783,  3.10028,
                           213.4425646,   0.54468,  5.380e-04,
                           -13.8021799,  -0.13295,  5.450e-04,
                           // 2032 10 18
                           2463524.294216,  19.0,    79.4, " 2.083", " 1.103",  1,
                           20.85453,  1.00194,  0.27300,
                           -2.56668, -1.57194, -0.33173,  0.06117,  0.45345,  1.69357,  2.69017,
                           23.9130711,   0.59700,  1.220e-04,
                           10.4143292,   0.16884, -6.100e-04,
                           // 2033  4 14
                           2463702.301289,  19.0,    79.8, " 2.171", " 1.094",  1,
                           8.55088,  0.90582,  0.24682,
                           -2.77948, -1.56046, -0.17891,  0.23093,  0.64118,  2.02279,  3.24030,
                           203.2924800,   0.48716,  2.850e-04,
                           -9.3536700,  -0.13909,  3.060e-04,
                           // 2033 10  8
                           2463878.955818,  11.0,    80.1, " 2.306", " 1.350",  1,
                           12.15961,  1.02419,  0.27907,
                           -2.66564, -1.74715, -0.71713, -0.06038,  0.59637,  1.62631,  2.54468,
                           14.3819793,   0.61173,  2.140e-04,
                           5.8215098,   0.19027, -3.270e-04,
                           // 2034  4  3
                           2464056.296519,  19.0,    80.4, " 0.855", "-0.227",  3,
                           7.81216,  0.90434,  0.24641,
                           -2.09593,  0.00000,  0.00000,  0.11646,  0.00000,  0.00000,  2.32758,
                           193.2175685,   0.47706,  2.400e-05,
                           -4.5774899,  -0.15075,  1.810e-04,
                           // 2034  9 28
                           2464233.616397,   3.0,    80.8, " 0.991", " 0.014",  2,
                           3.46470,  0.99948,  0.27234,
                           -2.27841, -0.42760,  0.00000, -0.20646,  0.00000,  0.01747,  1.86620,
                           5.0774004,   0.57788,  2.390e-04,
                           1.0889501,   0.18950,  1.200e-05,
                           // 2035  2 22
                           2464380.879305,   9.0,    81.1, " 0.965", "-0.053",  3,
                           19.14047,  0.97105,  0.26459,
                           -2.02783,  0.00000,  0.00000,  0.10332,  0.00000,  0.00000,  2.23332,
                           155.1434576,   0.55973, -4.900e-04,
                           9.2450598,  -0.15816, -3.650e-04,
                           // 2035  8 19
                           2464558.550177,   1.0,    81.4, " 1.151", " 0.104",  2,
                           22.81492,  0.92315,  0.25154,
                           -2.21059, -0.43198,  0.00000,  0.20425,  0.00000,  0.84335,  2.62022,
                           327.8561836,   0.51445, -7.800e-05,
                           -12.0544600,   0.12987,  5.140e-04,
                           // 2036  2 11
                           2464735.425767,  22.0,    81.8, " 2.275", " 1.299",  1,
                           7.43734,  1.01606,  0.27685,
                           -2.41503, -1.46447, -0.40241,  0.21840,  0.83894,  1.90094,  2.85264,
                           144.8934337,   0.62782, -5.360e-04,
                           13.6501194,  -0.14868, -7.550e-04,
                           // 2036  8  7
                           2464912.619820,   3.0,    82.1, " 2.527", " 1.454",  1,
                           0.08167,  0.89966,  0.24514,
                           -3.22524, -2.05210, -0.91864, -0.12433,  0.67000,  1.80350,  2.97660,
                           317.6887640,   0.50279, -2.460e-04,
                           -16.0830806,   0.10100,  5.890e-04,
                           // 2037  1 31
                           2465090.084473,  14.0,    82.5, " 2.180", " 1.207",  1,
                           22.74243,  1.02060,  0.27809,
                           -2.57384, -1.61810, -0.50330,  0.02734,  0.55822,  1.67304,  2.62792,
                           134.5470632,   0.65224, -3.260e-04,
                           17.5461908,  -0.11988, -1.087e-03,
                           // 2037  7 27
                           2465266.673533,   4.0,    82.8, " 1.858", " 0.809",  2,
                           0.34569,  0.91846,  0.25026,
                           -2.67510, -1.43929,  0.00000,  0.16480,  0.00000,  1.76761,  3.00530,
                           306.8162776,   0.54021, -4.220e-04,
                           -19.6531197,   0.07628,  7.840e-04,
                           // 2038  1 21
                           2465444.659625,   4.0,    83.2, " 0.900", "-0.114",  3,
                           12.04203,  0.98086,  0.26726,
                           -2.21650,  0.00000,  0.00000, -0.16900,  0.00000,  0.00000,  1.87996,
                           123.6573511,   0.62207, -6.300e-05,
                           20.9191602,  -0.07720, -1.159e-03,
                           // 2038  6 17
                           2465591.614603,   3.0,    83.5, " 0.442", "-0.527",  3,
                           20.69864,  0.99321,  0.27063,
                           -1.72048,  0.00000,  0.00000, -0.24952,  0.00000,  0.00000,  1.21833,
                           266.0278359,   0.64351,  7.200e-05,
                           -22.1028405,  -0.06987,  1.286e-03,
                           // 2038  7 16
                           2465620.983287,  12.0,    83.5, " 0.500", "-0.495",  3,
                           7.62887,  0.96732,  0.26357,
                           -2.00651,  0.00000,  0.00000, -0.40110,  0.00000,  0.00000,  1.20088,
                           296.3011194,   0.61446, -4.900e-04,
                           -22.5109699,   0.05004,  1.144e-03,
                           // 2038 12 11
                           2465769.239583,  18.0,    83.9, " 0.805", "-0.289",  3,
                           23.37035,  0.90828,  0.24749,
                           -2.40329,  0.00000,  0.00000, -0.25002,  0.00000,  0.00000,  1.90425,
                           79.2043284,   0.53569,  4.280e-04,
                           22.0367704,   0.08266, -8.520e-04,
                           // 2039  6  6
                           2465946.287794,  19.0,    84.2, " 1.827", " 0.885",  2,
                           12.00373,  1.02288,  0.27871,
                           -2.56578, -1.58722,  0.00000, -0.09295,  0.00000,  1.40105,  2.37971,
                           254.9191069,   0.67355,  5.460e-04,
                           -22.1572208,  -0.12354,  1.391e-03,
                           // 2039 11 30
                           2466123.205874,  17.0,    84.6, " 2.042", " 0.943",  2,
                           21.62889,  0.90247,  0.24590,
                           -3.05955, -1.77598,  0.00000, -0.05903,  0.00000,  1.65737,  2.94174,
                           66.7343838,   0.51672,  3.640e-04,
                           21.2865390,   0.12287, -8.040e-04,
                           // 2040  5 26
                           2466300.990527,  12.0,    85.0, " 2.494", " 1.535",  1,
                           4.31155,  1.00691,  0.27436,
                           -2.90581, -1.98314, -0.99593, -0.22734,  0.54153,  1.52894,  2.45023,
                           244.0346267,   0.63941,  9.080e-04,
                           -21.4949485,  -0.16286,  1.167e-03,
                           // 2040 11 18
                           2466477.294913,  19.0,    85.3, " 2.453", " 1.397",  1,
                           22.89564,  0.93813,  0.25562,
                           -2.86757, -1.75947, -0.65434,  0.07792,  0.80969,  1.91463,  3.02533,
                           54.6477698,   0.54043,  3.650e-04,
                           19.6932693,   0.17104, -8.760e-04,
                           // 2041  5 16
                           2466655.529892,   1.0,    85.7, " 1.075", " 0.064",  2,
                           16.60842,  0.95788,  0.26100,
                           -2.52950, -0.76792,  0.00000, -0.28259,  0.00000,  0.20637,  1.96593,
                           233.0363283,   0.56298,  8.980e-04,
                           -20.0752801,  -0.18227,  8.140e-04,
                           // 2041 11  8
                           2466831.691027,   5.0,    86.1, " 1.166", " 0.170",  2,
                           8.18430,  0.99132,  0.27011,
                           -2.64882, -1.16956,  0.00000, -0.41535,  0.00000,  0.33619,  1.81795,
                           43.5557099,   0.58208,  4.950e-04,
                           17.6031614,   0.22358, -9.400e-04,
                           // 2042  4  5
                           2466980.104293,  15.0,    86.4, " 0.868", "-0.218",  3,
                           3.93673,  0.90083,  0.24546,
                           -2.73409,  0.00000,  0.00000, -0.49696,  0.00000,  0.00000,  1.74000,
                           195.3737090,   0.44014,  2.110e-04,
                           -5.5044499,  -0.23043,  1.390e-04,
                           // 2042  9 29
                           2467156.948455,  11.0,    86.8, " 0.953", "-0.003",  3,
                           11.55642,  1.02165,  0.27837,
                           -2.22492,  0.00000,  0.00000, -0.23707,  0.00000,  0.00000,  1.75058,
                           6.5434898,   0.55814,  1.550e-04,
                           1.7070000,   0.30240, -4.400e-05,
                           // 2043  3 25
                           2467334.105596,  15.0,    87.2, " 2.190", " 1.114",  1,
                           3.19801,  0.91192,  0.24848,
                           -3.45929, -2.25459, -0.91096, -0.46569, -0.02094,  1.32240,  2.52847,
                           184.8194548,   0.44537, -5.400e-05,
                           -1.7291900,  -0.24297,  1.120e-04,
                           // 2043  9 19
                           2467511.577659,   2.0,    87.6, " 2.243", " 1.256",  1,
                           1.85877,  0.98577,  0.26860,
                           -2.85155, -1.85274, -0.73370, -0.13617,  0.46191,  1.58105,  2.57766,
                           356.5962809,   0.51954,  1.280e-04,
                           -1.8205400,   0.28385,  1.890e-04,
                           // 2044  3 13
                           2467688.318432,  20.0,    88.0, " 2.230", " 1.203",  1,
                           7.47298,  0.95808,  0.26105,
                           -3.17659, -2.10034, -0.91141, -0.35763,  0.19546,  1.38426,  2.46311,
                           174.3894691,   0.49152, -2.930e-04,
                           2.0438299,  -0.26762,  4.000e-05,
                           // 2044  9  7
                           2467865.972736,  11.0,    88.4, " 2.086", " 1.046",  1,
                           10.14469,  0.93322,  0.25428,
                           -2.52155, -1.37203,  0.06358,  0.34567,  0.62861,  2.06459,  3.21213,
                           346.2838973,   0.47093, -1.800e-05,
                           -5.4519599,   0.24920,  2.770e-04,
                           // 2045  3  3
                           2468042.821826,   8.0,    88.8, " 0.962", "-0.017",  3,
                           18.76711,  1.00795,  0.27464,
                           -2.30925,  0.00000,  0.00000, -0.27617,  0.00000,  0.00000,  1.75653,
                           164.1167416,   0.55002, -4.370e-04,
                           5.6334201,  -0.28701, -1.710e-04,
                           // 2045  8 27
                           2468220.079746,  14.0,    89.2, " 0.682", "-0.392",  3,
                           12.41418,  0.90130,  0.24558,
                           -2.09945,  0.00000,  0.00000, -0.08611,  0.00000,  0.00000,  1.92845,
                           336.1018338,   0.44867, -2.240e-04,
                           -8.7945405,   0.22099,  2.860e-04,
                           // 2046  1 22
                           2468368.043479,  13.0,    89.5, " 1.035", " 0.053",  2,
                           21.13649,  1.01278,  0.27596,
                           -2.03981, -0.37541,  0.00000,  0.04350,  0.00000,  0.46435,  2.12704,
                           125.2553831,   0.63192, -6.520e-04,
                           20.5182998,  -0.19760, -1.196e-03,
                           // 2046  7 18
                           2468544.545893,   1.0,    89.9, " 1.281", " 0.246",  2,
                           20.73428,  0.93041,  0.25351,
                           -2.38348, -0.85479,  0.00000,  0.10143,  0.00000,  1.05486,  2.58548,
                           297.7875598,   0.54676, -7.540e-04,
                           -21.8041905,   0.14458,  8.470e-04,
                           // 2047  1 12
                           2468722.559888,   1.0,    90.3, " 2.265", " 1.234",  1,
                           8.43063,  0.96507,  0.26296,
                           -2.37366, -1.30290, -0.14572,  0.43732,  1.02102,  2.17839,  3.24659,
                           113.3162056,   0.59322, -3.330e-04,
                           22.0505793,  -0.14043, -1.129e-03,
                           // 2047  7  7
                           2468898.941498,  11.0,    90.7, " 2.731", " 1.751",  1,
                           6.02294,  0.98226,  0.26764,
                           -3.18202, -2.22532, -1.24440, -0.40404,  0.43601,  1.41669,  2.37546,
                           286.8475912,   0.62235, -8.060e-04,
                           -22.5709202,   0.12108,  1.148e-03,
                           // 2048  1  1
                           2469076.787439,   7.0,    91.2, " 2.214", " 1.128",  1,
                           13.70833,  0.91603,  0.24960,
                           -3.09717, -1.88655, -0.56727, -0.10145,  0.36494,  1.68447,  2.89325,
                           101.4266973,   0.54676, -1.920e-04,
                           22.6702704,  -0.08713, -9.520e-04,
                           // 2048  6 26
                           2469253.585048,   2.0,    91.6, " 1.583", " 0.639",  2,
                           20.32528,  1.01984,  0.27788,
                           -2.33978, -1.28547,  0.00000,  0.04114,  0.00000,  1.36721,  2.42231,
                           275.5027562,   0.67934, -5.060e-04,
                           -22.6484104,   0.08178,  1.419e-03,
                           // 2048 12 20
                           2469430.769305,   6.0,    92.0, " 0.962", "-0.144",  3,
                           11.96687,  0.89973,  0.24516,
                           -1.88331,  0.00000,  0.00000,  0.46331,  0.00000,  0.00000,  2.80990,
                           88.6136449,   0.53284, -1.810e-04,
                           22.4957505,  -0.04008, -8.730e-04,
                           // 2049  5 17
                           2469578.976837,  11.0,    92.3, " 0.764", "-0.209",  3,
                           2.70562,  0.99498,  0.27111,
                           -1.42376,  0.00000,  0.00000,  0.44410,  0.00000,  0.00000,  2.31394,
                           234.2706801,   0.63663,  6.000e-04,
                           -20.5622094,  -0.08673,  1.131e-03,
                           // 2049  6 15
                           2469608.301526,  19.0,    92.4, " 0.251", "-0.699",  3,
                           12.63310,  1.01428,  0.27636,
                           -0.86202,  0.00000,  0.00000,  0.23663,  0.00000,  0.00000,  1.33751,
                           264.4414288,   0.67339,  1.300e-05,
                           -21.9247792,   0.03130,  1.377e-03,
                           // 2049 11  9
                           2469755.161242,  16.0,    92.8, " 0.681", "-0.355",  3,
                           19.28424,  0.95326,  0.25974,
                           -2.01524,  0.00000,  0.00000, -0.13020,  0.00000,  0.00000,  1.75245,
                           45.0746006,   0.57221,  1.100e-04,
                           18.2347387,   0.10724, -8.960e-04,
                           // 2050  5  6
                           2469933.438907,  23.0,    93.6, " 2.105", " 1.077",  1,
                           13.99975,  0.94288,  0.25691,
                           -3.30035, -2.18220, -0.82571, -0.46622, -0.10586,  1.25095,  2.36673,
                           224.3098737,   0.55673,  5.470e-04,
                           -17.2278596,  -0.10589,  7.220e-04,
                           // 2050 10 30
                           2470109.640126,   3.0,    94.6, " 2.034", " 1.054",  1,
                           5.57563,  1.00433,  0.27365,
                           -2.24586, -1.24446,  0.07525,  0.36302,  0.65014,  1.96976,  2.97293,
                           34.2338917,   0.61466,  2.030e-04,
                           14.1926695,   0.14771, -8.310e-04,
                           // 2051  4 26
                           2470287.594766,   2.0,    95.6, " 2.277", " 1.202",  1,
                           16.26924,  0.90456,  0.24647,
                           -2.76609, -1.56582, -0.30528,  0.27438,  0.85435,  2.11495,  3.31387,
                           213.4638338,   0.49697,  3.290e-04,
                           -13.1314297,  -0.12143,  4.560e-04,
                           // 2051 10 19
                           2470464.299880,  19.0,    96.6, " 2.371", " 1.412",  1,
                           20.88072,  1.02418,  0.27906,
                           -2.42122, -1.50526, -0.49924,  0.19711,  0.89348,  1.89945,  2.81521,
                           24.3945995,   0.62235,  3.540e-04,
                           9.8823207,   0.17503, -5.650e-04,
                           // 2052  4 14
                           2470641.595900,   2.0,    97.5, " 0.947", "-0.131",  3,
                           15.53052,  0.90560,  0.24676,
                           -1.99902,  0.00000,  0.00000,  0.30159,  0.00000,  0.00000,  2.60102,
                           203.1420929,   0.48580,  9.300e-05,
                           -8.6513097,  -0.13998,  3.310e-04,
                           // 2052 10  8
                           2470818.948582,  11.0,    98.5, " 1.064", " 0.082",  2,
                           12.18580,  0.99704,  0.27167,
                           -2.37219, -0.75990,  0.00000, -0.23402,  0.00000,  0.29457,  1.90471,
                           15.0380890,   0.58003,  3.820e-04,
                           5.3562297,   0.18095, -2.060e-04,
                           // 2053  3  4
                           2470966.223726,  17.0,    99.4, " 0.932", "-0.081",  3,
                           3.86157,  0.97388,  0.26536,
                           -1.72354,  0.00000,  0.00000,  0.36942,  0.00000,  0.00000,  2.46114,
                           165.3044842,   0.55369, -3.850e-04,
                           5.1470700,  -0.17337, -1.650e-04,
                           // 2053  8 29
                           2471143.837388,   8.0,   100.4, " 1.019", "-0.033",  3,
                           6.53328,  0.92068,  0.25087,
                           -2.21655,  0.00000,  0.00000,  0.09731,  0.00000,  0.00000,  2.41267,
                           337.9085008,   0.50097, -2.600e-05,
                           -8.2500096,   0.14618,  3.570e-04,
                           // 2054  2 22
                           2471320.785730,   7.0,   101.4, " 2.249", " 1.277",  1,
                           17.16118,  1.01741,  0.27722,
                           -2.76498, -1.81663, -0.74378, -0.14249,  0.45854,  1.53136,  2.48076,
                           155.7577512,   0.61403, -4.470e-04,
                           9.7460900,  -0.17316, -5.120e-04,
                           // 2054  8 18
                           2471497.893403,   9.0,   102.4, " 2.381", " 1.306",  1,
                           6.79730,  0.89957,  0.24511,
                           -2.63698, -1.44601, -0.24956,  0.44168,  1.13292,  2.32942,  3.52055,
                           327.6670420,   0.49020, -2.390e-04,
                           -12.7614802,   0.12223,  4.510e-04,
                           // 2055  2 11
                           2471675.448813,  23.0,   103.4, " 2.197", " 1.225",  1,
                           8.46626,  1.01940,  0.27776,
                           -2.83599, -1.88187, -0.77829, -0.22848,  0.32159,  1.42520,  2.37833,
                           145.7453222,   0.63251, -3.090e-04,
                           14.1012098,  -0.15181, -8.520e-04,
                           // 2055  8  7
                           2471851.953682,  11.0,   104.4, " 2.007", " 0.959",  2,
                           8.06405,  0.92086,  0.25091,
                           -2.99733, -1.80702,  0.00000, -0.11163,  0.00000,  1.58263,  2.77489,
                           317.5654654,   0.52856, -4.640e-04,
                           -16.7623412,   0.10573,  6.400e-04,
                           // 2056  2  1
                           2472030.018123,  12.0,   105.4, " 0.906", "-0.110",  3,
                           20.76314,  0.97811,  0.26651,
                           -1.62466,  0.00000,  0.00000,  0.43494,  0.00000,  0.00000,  2.49592,
                           134.7674597,   0.60175, -1.320e-04,
                           18.1616711,  -0.11207, -9.840e-04,
                           // 2056  6 27
                           2472176.918855,  10.0,   106.2, " 0.314", "-0.652",  3,
                           4.41700,  0.99606,  0.27140,
                           -1.19864,  0.00000,  0.00000,  0.05252,  0.00000,  0.00000,  1.30031,
                           277.1115663,   0.65026, -1.310e-04,
                           -21.9000488,  -0.02380,  1.285e-03,
                           // 2056  7 26
                           2472206.280144,  19.0,   106.4, " 0.643", "-0.349",  3,
                           15.34723,  0.97065,  0.26448,
                           -2.06503,  0.00000,  0.00000, -0.27655,  0.00000,  0.00000,  1.50905,
                           307.1902714,   0.60448, -6.030e-04,
                           -20.2608204,   0.08754,  9.990e-04,
                           // 2056 12 22
                           2472354.575645,   2.0,   107.2, " 0.786", "-0.311",  3,
                           8.09145,  0.90692,  0.24712,
                           -2.32106,  0.00000,  0.00000, -0.18452,  0.00000,  0.00000,  1.95308,
                           91.2173403,   0.54098,  2.680e-04,
                           22.3916789,   0.04107, -8.900e-04,
                           // 2057  6 17
                           2472531.601621,   2.0,   108.2, " 1.697", " 0.755",  2,
                           19.72209,  1.02322,  0.27880,
                           -1.98257, -0.97213,  0.00000,  0.43890,  0.00000,  1.84973,  2.86022,
                           265.8891557,   0.68494,  3.570e-04,
                           -22.7238498,  -0.07628,  1.461e-03,
                           // 2057 12 11
                           2472708.537245,   1.0,   109.2, " 2.018", " 0.918",  2,
                           6.34999,  0.90338,  0.24615,
                           -3.09573, -1.80658,  0.00000, -0.10612,  0.00000,  1.59372,  2.88384,
                           78.6717308,   0.53148,  2.470e-04,
                           22.5906697,   0.08438, -8.860e-04,
                           // 2058  6  6
                           2472886.302639,  19.0,   110.2, " 2.621", " 1.661",  1,
                           12.02991,  1.00449,  0.27370,
                           -2.43401, -1.51456, -0.54752,  0.26334,  1.07446,  2.04168,  2.95964,
                           254.9760434,   0.65316,  7.820e-04,
                           -22.8174405,  -0.11922,  1.292e-03,
                           // 2058 11 30
                           2473062.636318,   3.0,   111.3, " 2.480", " 1.426",  1,
                           7.61674,  0.94078,  0.25634,
                           -2.66895, -1.56762, -0.47594,  0.27163,  1.01873,  2.11021,  3.21413,
                           66.1814800,   0.56302,  3.070e-04,
                           21.8238102,   0.13536, -1.009e-03,
                           // 2059  5 27
                           2473240.830262,   8.0,   112.3, " 1.195", " 0.183",  2,
                           0.32678,  0.95462,  0.26011,
                           -2.42083, -0.88191,  0.00000, -0.07371,  0.00000,  0.73776,  2.27457,
                           243.9907223,   0.57865,  8.500e-04,
                           -22.1634499,  -0.14600,  9.590e-04,
                           // 2059 11 19
                           2473417.042778,  13.0,   113.3, " 1.204", " 0.208",  2,
                           16.90540,  0.99396,  0.27083,
                           -2.22750, -0.80159,  0.00000,  0.02667,  0.00000,  0.85245,  2.28071,
                           54.5853385,   0.60838,  5.260e-04,
                           20.3686008,   0.19115, -1.126e-03,
                           // 2060  4 15
                           2473565.400738,  22.0,   114.1, " 0.767", "-0.316",  3,
                           11.65510,  0.90029,  0.24531,
                           -2.50705,  0.00000,  0.00000, -0.38228,  0.00000,  0.00000,  1.74235,
                           205.3953314,   0.44953,  3.170e-04,
                           -9.4327901,  -0.21855,  2.690e-04,
                           // 2060 10  9
                           2473742.287172,  19.0,   115.2, " 0.880", "-0.080",  3,
                           20.27752,  1.02083,  0.27815,
                           -2.03573,  0.00000,  0.00000, -0.10787,  0.00000,  0.00000,  1.81997,
                           16.4741397,   0.56446,  3.760e-04,
                           5.8413601,   0.29347, -2.390e-04,
                           // 2060 11  8
                           2473771.669621,   4.0,   115.3, " 0.027", "-0.938",  3,
                           7.20775,  1.02406,  0.27903,
                           -0.29288,  0.00000,  0.00000,  0.07091,  0.00000,  0.00000,  0.43410,
                           43.3863588,   0.62296,  8.140e-04,
                           18.2087191,   0.23714, -1.020e-03,
                           // 2061  4  4
                           2473919.412555,  22.0,   116.2, " 2.104", " 1.034",  1,
                           10.91637,  0.91379,  0.24899,
                           -3.05715, -1.84606, -0.34809, -0.09869,  0.15009,  1.64775,  2.86026,
                           194.6423050,   0.45244,  7.200e-05,
                           -5.8343502,  -0.23832,  2.440e-04,
                           // 2061  9 29
                           2474096.901540,  10.0,   117.2, " 2.156", " 1.162",  1,
                           10.57987,  0.98290,  0.26782,
                           -3.07039, -2.04953, -0.85450, -0.36303,  0.12911,  1.32422,  2.34279,
                           6.5947901,   0.51753,  3.210e-04,
                           2.4656601,   0.28116,  1.500e-05,
                           // 2062  3 25
                           2474273.648500,   4.0,   118.2, " 2.291", " 1.270",  1,
                           16.19408,  0.96103,  0.26186,
                           -3.25458, -2.19742, -1.05841, -0.43601,  0.18578,  1.32466,  2.38437,
                           184.4485209,   0.49433, -1.210e-04,
                           -2.2782198,  -0.26959,  2.010e-04,
                           // 2062  9 18
                           2474451.273636,  19.0,   119.2, " 2.196", " 1.150",  1,
                           18.86579,  0.93048,  0.25353,
                           -3.34369, -2.20258, -0.92837, -0.43273,  0.06361,  1.33817,  2.47731,
                           356.4913145,   0.46356,  1.290e-04,
                           -1.1198099,   0.25326,  1.290e-04,
                           // 2063  3 14
                           2474628.170711,  16.0,   120.3, " 1.009", " 0.034",  2,
                           3.48821,  1.00984,  0.27516,
                           -1.96825, -0.24258,  0.00000,  0.09707,  0.00000,  0.43458,  2.16217,
                           174.0554591,   0.54548, -2.260e-04,
                           1.4810400,  -0.29594,  1.700e-05,
                           // 2063  9  7
                           2474805.361944,  21.0,   121.3, " 0.810", "-0.268",  3,
                           20.13254,  0.90062,  0.24540,
                           -2.48298,  0.00000,  0.00000, -0.31334,  0.00000,  0.00000,  1.85733,
                           346.1027334,   0.43879, -1.160e-04,
                           -4.8230702,   0.23141,  1.570e-04,
                           // 2064  2  2
                           2474953.408989,  22.0,   122.2, " 1.020", " 0.038",  2,
                           6.86033,  1.01097,  0.27546,
                           -2.25950, -0.53777,  0.00000, -0.18427,  0.00000,  0.17133,  1.89118,
                           136.8168033,   0.60454, -6.150e-04,
                           17.5579899,  -0.23343, -9.820e-04,
                           // 2064  7 28
                           2475129.828329,   8.0,   123.2, " 1.136", " 0.104",  2,
                           4.45264,  0.93330,  0.25430,
                           -2.48965, -0.75251,  0.00000, -0.12009,  0.00000,  0.50907,  2.24811,
                           308.8145451,   0.53078, -7.900e-04,
                           -19.5628297,   0.17843,  7.080e-04,
                           // 2065  1 22
                           2475307.915955,  10.0,   124.2, " 2.256", " 1.223",  1,
                           18.15447,  0.96227,  0.26220,
                           -2.83608, -1.75817, -0.58980, -0.01708,  0.55630,  1.72484,  2.80012,
                           125.3402687,   0.56870, -3.980e-04,
                           19.8015500,  -0.17975, -9.770e-04,
                           // 2065  7 17
                           2475484.242135,  18.0,   125.2, " 2.589", " 1.612",  1,
                           13.74130,  0.98541,  0.26850,
                           -2.94680, -1.99131, -0.99732, -0.18876,  0.61945,  1.61318,  2.57066,
                           297.8574463,   0.60908, -9.160e-04,
                           -21.0949197,   0.16279,  1.021e-03,
                           // 2066  1 11
                           2475662.128325,  15.0,   126.3, " 2.226", " 1.138",  1,
                           22.42944,  0.91423,  0.24911,
                           -2.92664, -1.71291, -0.40266,  0.07981,  0.56282,  1.87333,  3.08533,
                           113.3109122,   0.53052, -3.140e-04,
                           21.3673196,  -0.12625, -8.670e-04,
                           // 2066  7  7
                           2475838.896174,  10.0,   127.3, " 1.718", " 0.775",  2,
                           5.04638,  1.02089,  0.27817,
                           -2.92778, -1.91964,  0.00000, -0.49183,  0.00000,  0.93564,  1.94452,
                           287.1405517,   0.66759, -7.010e-04,
                           -21.8477312,   0.13151,  1.326e-03,
                           // 2066 12 31
                           2476016.104280,  15.0,   128.4, " 0.977", "-0.128",  3,
                           21.69071,  0.90009,  0.24525,
                           -2.85817,  0.00000,  0.00000, -0.49728,  0.00000,  0.00000,  1.86362,
                           101.1959393,   0.52581, -3.410e-04,
                           22.0621804,  -0.08266, -8.340e-04,
                           // 2067  5 28
                           2476164.288977,  19.0,   129.2, " 0.640", "-0.333",  3,
                           11.42672,  0.99209,  0.27032,
                           -1.80106,  0.00000,  0.00000, -0.06456,  0.00000,  0.00000,  1.67431,
                           245.7158915,   0.64788,  4.600e-04,
                           -22.7536499,  -0.04465,  1.290e-03,
                           // 2067  6 27
                           2476193.611877,   3.0,   129.4, " 0.375", "-0.575",  3,
                           21.35421,  1.01238,  0.27585,
                           -1.64578,  0.00000,  0.00000, -0.31496,  0.00000,  0.00000,  1.01805,
                           276.1013540,   0.66628, -2.120e-04,
                           -21.9428109,   0.08148,  1.362e-03,
                           // 2067 11 21
                           2476340.503264,   0.0,   130.3, " 0.654", "-0.381",  3,
                           4.00534,  0.95616,  0.26053,
                           -1.76886,  0.00000,  0.00000,  0.07834,  0.00000,  0.00000,  1.92296,
                           56.3041487,   0.59185,  4.000e-05,
                           21.0117895,   0.07376, -1.056e-03,
                           // 2068  5 17
                           2476518.737697,   6.0,   131.3, " 1.983", " 0.953",  2,
                           21.71811,  0.93984,  0.25608,
                           -3.10116, -1.95278,  0.00000, -0.29527,  0.00000,  1.36360,  2.50962,
                           234.9923852,   0.56770,  4.960e-04,
                           -19.9928397,  -0.07425,  8.740e-04,
                           // 2068 11  9
                           2476694.990969,  12.0,   132.3, " 1.996", " 1.015",  1,
                           15.29947,  1.00658,  0.27427,
                           -2.80921, -1.80227, -0.37003, -0.21673, -0.06409,  1.36806,  2.37666,
                           45.4946196,   0.63515,  2.140e-04,
                           17.6453498,   0.11668, -1.054e-03,
                           // 2069  5  6
                           2476872.881904,   9.0,   133.4, " 2.396", " 1.323",  1,
                           23.98761,  0.90342,  0.24616,
                           -2.90244, -1.71895, -0.53666,  0.16570,  0.86829,  2.05065,  3.23298,
                           223.9482288,   0.50893,  3.330e-04,
                           -16.4908600,  -0.09789,  6.010e-04,
                           // 2069 10 30
                           2477049.649371,   4.0,   134.4, " 2.424", " 1.462",  1,
                           6.60456,  1.02402,  0.27902,
                           -3.04379, -2.12854, -1.13810, -0.41509,  0.30796,  1.29838,  2.21335,
                           35.2764586,   0.63784,  4.440e-04,
                           13.7803002,   0.15036, -8.130e-04,
                           // 2070  4 25
                           2477226.889862,   9.0,   135.5, " 1.052", "-0.021",  3,
                           23.24888,  0.90702,  0.24714,
                           -2.03484,  0.00000,  0.00000,  0.35669,  0.00000,  0.00000,  2.74721,
                           213.2846370,   0.49815,  1.370e-04,
                           -12.4327201,  -0.12315,  4.790e-04,
                           // 2070 10 19
                           2477404.285550,  19.0,   136.5, " 1.126", " 0.138",  2,
                           20.90690,  0.99455,  0.27099,
                           -2.33955, -0.82620,  0.00000, -0.14680,  0.00000,  0.53523,  2.04641,
                           25.1479898,   0.58710,  5.000e-04,
                           9.4271295,   0.16500, -4.240e-04,
                           // 2071  3 16
                           2477551.563303,   2.0,   137.4, " 0.888", "-0.119",  3,
                           13.58541,  0.97672,  0.26613,
                           -2.52408,  0.00000,  0.00000, -0.48072,  0.00000,  0.00000,  1.56129,
                           175.8690383,   0.55195, -2.550e-04,
                           0.6762700,  -0.18138,  4.600e-05,
                           // 2071  9  9
                           2477729.128945,  15.0,   138.5, " 0.899", "-0.159",  3,
                           14.25164,  0.91836,  0.25023,
                           -2.11411,  0.00000,  0.00000,  0.09467,  0.00000,  0.00000,  2.30526,
                           347.7575789,   0.49132,  5.100e-05,
                           -4.1704102,   0.15623,  1.990e-04,
                           // 2072  3  4
                           2477906.141054,  15.0,   139.5, " 2.213", " 1.244",  1,
                           1.88228,  1.01863,  0.27755,
                           -2.22398, -1.27662, -0.18529,  0.38530,  0.95565,  2.04697,  2.99529,
                           165.7610277,   0.60521, -3.110e-04,
                           5.6825300,  -0.18849, -2.800e-04,
                           // 2072  8 28
                           2478083.170627,  16.0,   140.6, " 2.243", " 1.166",  1,
                           14.51566,  0.89963,  0.24513,
                           -2.95472, -1.74095, -0.43995,  0.09505,  0.62999,  1.93103,  3.14518,
                           337.8472204,   0.47950, -1.940e-04,
                           -8.9319605,   0.13869,  3.040e-04,
                           // 2073  2 22
                           2478260.808945,   7.0,   141.6, " 2.222", " 1.250",  1,
                           17.18737,  1.01804,  0.27739,
                           -2.20093, -1.24963, -0.16164,  0.41467,  0.99125,  2.07927,  3.02947,
                           155.9896498,   0.61573, -2.160e-04,
                           10.3419301,  -0.17375, -6.200e-04,
                           // 2073  8 17
                           2478437.237977,  18.0,   142.7, " 2.148", " 1.101",  1,
                           15.78241,  0.92334,  0.25159,
                           -3.20855, -2.05197, -0.70671, -0.28855,  0.12889,  1.47386,  2.63247,
                           327.9556584,   0.51737, -4.510e-04,
                           -13.3523701,   0.12947,  4.820e-04,
                           // 2074  2 11
                           2478615.372194,  21.0,   143.7, " 0.919", "-0.097",  3,
                           6.48698,  0.97529,  0.26574,
                           -2.14582,  0.00000,  0.00000, -0.06735,  0.00000,  0.00000,  2.01240,
                           146.1082785,   0.58110, -1.290e-04,
                           14.6788296,  -0.14122, -7.830e-04,
                           // 2074  7  8
                           2478762.223352,  17.0,   144.6, " 0.187", "-0.777",  3,
                           12.13537,  0.99881,  0.27215,
                           -0.61322,  0.00000,  0.00000,  0.36045,  0.00000,  0.00000,  1.33048,
                           288.0870246,   0.64965, -3.230e-04,
                           -20.9191807,   0.02158,  1.220e-03,
                           // 2074  8  7
                           2478791.580596,   2.0,   144.8, " 0.781", "-0.209",  3,
                           23.06560,  0.97395,  0.26538,
                           -2.00168,  0.00000,  0.00000, -0.06570,  0.00000,  0.00000,  1.86789,
                           317.7175874,   0.59233, -6.420e-04,
                           -17.4019901,   0.11967,  8.230e-04,
                           // 2075  1  2
                           2478939.913232,  10.0,   145.7, " 0.771", "-0.327",  3,
                           16.81255,  0.90568,  0.24678,
                           -2.20647,  0.00000,  0.00000, -0.08244,  0.00000,  0.00000,  2.04268,
                           103.2149842,   0.53911,  9.800e-05,
                           21.8225586,  -0.00034, -8.740e-04,
                           // 2075  6 28
                           2479116.913605,  10.0,   146.8, " 1.562", " 0.622",  2,
                           4.44319,  1.02340,  0.27885,
                           -2.43534, -1.38157,  0.00000, -0.07347,  0.00000,  1.23454,  2.28833,
                           277.5810462,   0.68870,  1.120e-04,
                           -22.5465296,  -0.02486,  1.466e-03,
                           // 2075 12 22
                           2479293.872166,   9.0,   147.8, " 2.001", " 0.901",  2,
                           15.07109,  0.90439,  0.24643,
                           -3.04814, -1.75615,  0.00000, -0.06803,  0.00000,  1.61945,  2.91256,
                           90.7510638,   0.54002,  8.500e-05,
                           22.9853505,   0.04330, -9.220e-04,
                           // 2076  6 17
                           2479471.610955,   3.0,   148.9, " 2.755", " 1.794",  1,
                           20.75102,  1.00195,  0.27301,
                           -3.04889, -2.12926, -1.17167, -0.33708,  0.49774,  1.45551,  2.37355,
                           266.7513441,   0.66160,  5.710e-04,
                           -23.4596900,  -0.06997,  1.372e-03,
                           // 2076 12 10
                           2479647.982540,  12.0,   150.0, " 2.499", " 1.446",  1,
                           17.34059,  0.94344,  0.25706,
                           -3.35286, -2.25785, -1.17586, -0.41904,  0.33733,  1.41909,  2.51667,
                           78.5598864,   0.58190,  1.660e-04,
                           23.2319698,   0.09238, -1.109e-03,
                           // 2077  6  6
                           2479826.124909,  15.0,   151.0, " 1.326", " 0.312",  2,
                           8.04515,  0.95135,  0.25922,
                           -2.44842, -1.04274,  0.00000, -0.00219,  0.00000,  1.04123,  2.44470,
                           255.2358638,   0.59056,  7.260e-04,
                           -23.5345096,  -0.10550,  1.070e-03,
                           // 2077 11 29
                           2480002.399921,  22.0,   152.1, " 1.231", " 0.236",  2,
                           2.62924,  0.99648,  0.27152,
                           -2.66862, -1.27769,  0.00000, -0.40190,  0.00000,  0.47155,  1.86468,
                           66.5721190,   0.63429,  4.550e-04,
                           22.5964514,   0.14928, -1.301e-03,
                           // 2078  4 27
                           2480150.691483,   5.0,   153.0, " 0.656", "-0.425",  3,
                           19.37346,  0.89989,  0.24520,
                           -2.38984,  0.00000,  0.00000, -0.40441,  0.00000,  0.00000,  1.58090,
                           215.6565295,   0.46308,  4.000e-04,
                           -13.0402202,  -0.20104,  4.000e-04,
                           // 2078 10 21
                           2480327.630586,   3.0,   154.1, " 0.817", "-0.146",  3,
                           4.99863,  1.01988,  0.27789,
                           -1.73939,  0.00000,  0.00000,  0.13406,  0.00000,  0.00000,  2.00769,
                           26.5563304,   0.57676,  5.760e-04,
                           9.7603907,   0.27723, -4.380e-04,
                           // 2078 11 19
                           2480357.027822,  13.0,   154.2, " 0.061", "-0.905",  3,
                           16.93159,  1.02452,  0.27915,
                           -0.88275,  0.00000,  0.00000, -0.33226,  0.00000,  0.00000,  0.21790,
                           54.9906897,   0.64981,  8.500e-04,
                           21.1490712,   0.19954, -1.249e-03,
                           // 2079  4 16
                           2480504.715799,   5.0,   155.1, " 2.010", " 0.945",  2,
                           18.63474,  0.91579,  0.24953,
                           -2.73805, -1.51628,  0.00000,  0.17916,  0.00000,  1.87352,  3.09679,
                           204.6062806,   0.46470,  1.870e-04,
                           -9.7512101,  -0.22794,  3.780e-04,
                           // 2079 10 10
                           2480682.229513,  18.0,   156.2, " 2.079", " 1.079",  1,
                           19.30097,  0.98003,  0.26703,
                           -3.19097, -2.14715, -0.84462, -0.49169, -0.13796,  1.16465,  2.20609,
                           16.6632505,   0.52193,  5.050e-04,
                           6.6647603,   0.27167, -1.610e-04,
                           // 2080  4  4
                           2480858.974751,  11.0,   157.3, " 2.361", " 1.346",  1,
                           23.91245,  0.96403,  0.26267,
                           -2.42433, -1.38615, -0.29078,  0.39401,  1.07828,  2.17349,  3.21417,
                           194.0577364,   0.50344,  4.000e-05,
                           -6.2732000,  -0.26564,  3.550e-04,
                           // 2080  9 29
                           2481036.578261,   2.0,   158.4, " 2.297", " 1.244",  1,
                           2.58415,  0.92786,  0.25282,
                           -3.06991, -1.93264, -0.73621, -0.12172,  0.49334,  1.69010,  2.82541,
                           6.2044303,   0.46185,  2.700e-04,
                           3.0100300,   0.25102, -9.000e-06,
                           // 2081  3 25
                           2481213.515293,   0.0,   159.5, " 1.065", " 0.095",  2,
                           12.20932,  1.01164,  0.27565,
                           -1.73638, -0.19305,  0.00000,  0.36703,  0.00000,  0.92523,  2.47037,
                           183.9467752,   0.54745, -7.000e-06,
                           -2.7485298,  -0.29777,  2.040e-04,
                           // 2081  9 18
                           2481390.649604,   4.0,   160.5, " 0.927", "-0.154",  3,
                           3.85091,  0.90009,  0.24525,
                           -2.70655,  0.00000,  0.00000, -0.40949,  0.00000,  0.00000,  1.88847,
                           355.9714005,   0.43403,  3.000e-06,
                           -0.6755000,   0.23626,  3.200e-05,
                           // 2082  2 13
                           2481538.770357,   6.0,   161.5, " 0.996", " 0.013",  2,
                           15.58144,  1.00902,  0.27493,
                           -1.57111,  0.27718,  0.00000,  0.48856,  0.00000,  0.70224,  2.54851,
                           147.4132544,   0.58020, -4.960e-04,
                           14.2437798,  -0.25932, -7.780e-04,
                           // 2082  8  8
                           2481715.115759,  15.0,   162.5, " 1.001", "-0.029",  3,
                           12.17101,  0.93624,  0.25510,
                           -2.47067,  0.00000,  0.00000, -0.22179,  0.00000,  0.00000,  2.02524,
                           319.4898302,   0.51434, -7.590e-04,
                           -16.7087703,   0.20692,  5.550e-04,
                           // 2083  2  2
                           2481893.268585,  18.0,   163.6, " 2.240", " 1.205",  1,
                           2.87557,  0.95944,  0.26142,
                           -2.37898, -1.29342, -0.10800,  0.44604,  1.00077,  2.18635,  3.26922,
                           136.4432057,   0.54381, -3.760e-04,
                           16.9959900,  -0.21028, -8.120e-04,
                           // 2083  7 29
                           2482069.545535,   1.0,   164.7, " 2.452", " 1.477",  1,
                           21.45967,  0.98849,  0.26934,
                           -2.63988, -1.68155, -0.66086,  0.09285,  0.84614,  1.86655,  2.82677,
                           308.5844770,   0.59237, -9.440e-04,
                           -18.9366397,   0.19987,  8.610e-04,
                           // 2084  1 22
                           2482247.467361,  23.0,   165.8, " 2.241", " 1.151",  1,
                           7.15054,  0.91251,  0.24864,
                           -2.80042, -1.58513, -0.28756,  0.21667,  0.72141,  2.01925,  3.23290,
                           124.9274521,   0.51038, -3.690e-04,
                           19.2336505,  -0.16068, -7.480e-04,
                           // 2084  7 17
                           2482424.207534,  17.0,   166.9, " 1.854", " 0.912",  2,
                           12.76475,  1.02178,  0.27841,
                           -2.50326, -1.53063,  0.00000, -0.01918,  0.00000,  1.49210,  2.46540,
                           297.9280158,   0.65085, -8.050e-04,
                           -20.3994511,   0.17488,  1.190e-03,
                           // 2085  1 10
                           2482601.439230,  23.0,   168.0, " 0.993", "-0.112",  3,
                           6.41182,  0.90057,  0.24538,
                           -2.83236,  0.00000,  0.00000, -0.45848,  0.00000,  0.00000,  1.91545,
                           113.0991354,   0.51305, -4.530e-04,
                           20.7625286,  -0.12116, -7.510e-04,
                           // 2085  6  8
                           2482749.595558,   2.0,   168.9, " 0.506", "-0.468",  3,
                           19.14509,  0.98909,  0.26950,
                           -1.27620,  0.00000,  0.00000,  0.29338,  0.00000,  0.00000,  1.86581,
                           256.8217791,   0.65252,  2.630e-04,
                           -24.1510998,  -0.00090,  1.388e-03,
                           // 2085  7  7
                           2482778.919906,  10.0,   169.1, " 0.505", "-0.448",  3,
                           5.07257,  1.01034,  0.27529,
                           -1.45007,  0.00000,  0.00000,  0.07775,  0.00000,  0.00000,  1.60773,
                           287.0504205,   0.65186, -3.800e-04,
                           -21.2218400,   0.12705,  1.286e-03,
                           // 2085 12  1
                           2482925.851104,   8.0,   170.0, " 0.639", "-0.396",  3,
                           12.72644,  0.95902,  0.26131,
                           -1.39538,  0.00000,  0.00000,  0.42650,  0.00000,  0.00000,  2.24565,
                           67.8721635,   0.60850, -1.060e-04,
                           23.0688393,   0.03405, -1.180e-03,
                           // 2086  5 28
                           2483104.030400,  13.0,   171.1, " 1.849", " 0.818",  2,
                           5.43648,  0.93683,  0.25526,
                           -3.03738, -1.84819,  0.00000, -0.27039,  0.00000,  1.30896,  2.49579,
                           246.0286322,   0.57624,  3.810e-04,
                           -22.1142606,  -0.03772,  9.960e-04,
                           // 2086 11 20
                           2483280.347017,  20.0,   172.2, " 1.968", " 0.986",  2,
                           0.02058,  1.00870,  0.27485,
                           -2.25051, -1.23971,  0.00000,  0.32841,  0.00000,  1.89578,  2.90812,
                           56.4775194,   0.65495,  1.480e-04,
                           20.3739301,   0.07991, -1.245e-03,
                           // 2087  5 17
                           2483458.163428,  16.0,   173.3, " 2.528", " 1.455",  1,
                           7.70597,  0.90241,  0.24589,
                           -3.16937, -1.99964, -0.87008, -0.07772,  0.71481,  1.84444,  3.01320,
                           234.7833814,   0.52114,  2.860e-04,
                           -19.3052411,  -0.06878,  7.310e-04,
                           // 2087 11 10
                           2483635.003858,  12.0,   174.4, " 2.465", " 1.501",  1,
                           15.32566,  1.02370,  0.27893,
                           -2.54463, -1.62877, -0.64852,  0.09260,  0.83378,  1.81403,  2.72953,
                           45.8381987,   0.65460,  4.690e-04,
                           17.0555595,   0.11915, -1.039e-03,
                           // 2088  5  5
                           2483812.178356,  16.0,   175.5, " 1.170", " 0.102",  2,
                           6.96725,  0.90859,  0.24757,
                           -2.20240, -0.36308,  0.00000,  0.28053,  0.00000,  0.92222,  2.76268,
                           223.7177373,   0.51281,  1.420e-04,
                           -15.7969298,  -0.10024,  6.220e-04,
                           // 2088 10 30
                           2483989.627315,   3.0,   176.6, " 1.176", " 0.183",  2,
                           5.62801,  0.99202,  0.27030,
                           -2.18181, -0.72342,  0.00000,  0.05557,  0.00000,  0.83716,  2.29336,
                           35.5007005,   0.59787,  5.760e-04,
                           13.1714896,   0.14173, -6.370e-04,
                           // 2089  3 26
                           2484136.898768,  10.0,   177.5, " 0.833", "-0.168",  3,
                           22.30652,  0.97958,  0.26691,
                           -2.41175,  0.00000,  0.00000, -0.42957,  0.00000,  0.00000,  1.55108,
                           185.8462508,   0.55642, -1.200e-04,
                           -3.6739400,  -0.18185,  2.500e-04,
                           // 2089  9 19
                           2484314.424501,  22.0,   178.6, " 0.789", "-0.274",  3,
                           21.97001,  0.91618,  0.24964,
                           -1.91266,  0.00000,  0.00000,  0.18802,  0.00000,  0.00000,  2.29075,
                           357.4976746,   0.48618,  1.410e-04,
                           0.0629400,   0.16016,  4.300e-05,
                           // 2090  3 15
                           2484491.492021,   0.0,   179.7, " 2.166", " 1.201",  1,
                           11.60613,  1.01973,  0.27785,
                           -2.78503, -1.83710, -0.71667, -0.19149,  0.33345,  1.45389,  2.40272,
                           176.2237027,   0.60114, -1.480e-04,
                           1.2404900,  -0.19624, -3.400e-05,
                           // 2090  9  8
                           2484668.453117,  23.0,   180.8, " 2.117", " 1.038",  1,
                           22.23403,  0.89985,  0.24519,
                           -3.14144, -1.90089, -0.39067, -0.12518,  0.14019,  1.65046,  2.89158,
                           347.8014014,   0.47243, -1.250e-04,
                           -4.8233199,   0.14916,  1.560e-04,
                           // 2091  3  5
                           2484846.165537,  16.0,   182.0, " 2.254", " 1.283",  1,
                           2.91121,  1.01654,  0.27698,
                           -2.65225, -1.70445, -0.63426, -0.02710,  0.58033,  1.65056,  2.59717,
                           166.6024933,   0.60288, -8.100e-05,
                           6.0866100,  -0.18858, -3.750e-04,
                           // 2091  8 29
                           2485022.526676,   1.0,   183.1, " 2.281", " 1.235",  1,
                           23.50078,  0.92591,  0.25229,
                           -3.30403, -2.17288, -0.96728, -0.35977,  0.24713,  1.45243,  2.58571,
                           338.0311710,   0.50854, -3.980e-04,
                           -9.5493097,   0.14720,  3.180e-04,
                           // 2092  2 23
                           2485200.722904,   5.0,   184.2, " 0.938", "-0.079",  3,
                           15.20808,  0.97242,  0.26496,
                           -1.75269,  0.00000,  0.00000,  0.34970,  0.00000,  0.00000,  2.45327,
                           156.5306964,   0.56322, -6.200e-05,
                           10.8627397,  -0.16081, -5.820e-04,
                           // 2092  7 19
                           2485347.529142,   1.0,   185.1, " 0.062", "-0.899",  3,
                           20.85647,  1.00148,  0.27288,
                           -0.86701,  0.00000,  0.00000, -0.30059,  0.00000,  0.00000,  0.26193,
                           299.4881950,   0.64198, -4.780e-04,
                           -19.1413490,   0.06636,  1.090e-03,
                           // 2092  8 17
                           2485376.884711,   9.0,   185.3, " 0.913", "-0.076",  3,
                           6.78396,  0.97720,  0.26626,
                           -1.82378,  0.00000,  0.00000,  0.23307,  0.00000,  0.00000,  2.28797,
                           327.8852802,   0.58054, -6.150e-04,
                           -14.0494302,   0.14569,  6.320e-04,
                           // 2093  1 12
                           2485525.250030,  18.0,   186.2, " 0.755", "-0.344",  3,
                           1.53366,  0.90454,  0.24647,
                           -2.10770,  0.00000,  0.00000,  0.00071,  0.00000,  0.00000,  2.11024,
                           115.0471736,   0.53082, -4.600e-05,
                           20.3597694,  -0.03930, -8.080e-04,
                           // 2093  7  8
                           2485702.225204,  17.0,   187.4, " 1.427", " 0.487",  2,
                           12.16156,  1.02341,  0.27885,
                           -1.88947, -0.77720,  0.00000,  0.40489,  0.00000,  1.58704,  2.69930,
                           288.4863175,   0.68389, -9.600e-05,
                           -21.5313791,   0.02235,  1.393e-03,
                           // 2094  1  1
                           2485879.208403,  17.0,   188.5, " 1.986", " 0.887",  2,
                           23.79220,  0.90552,  0.24673,
                           -2.96847, -1.67546,  0.00000,  0.00167,  0.00000,  1.67811,  2.97239,
                           102.8125358,   0.54131, -9.000e-05,
                           22.4492096,   0.00190, -9.020e-04,
                           // 2094  6 28
                           2486056.918018,  10.0,   189.6, " 2.786", " 1.823",  1,
                           4.46938,  0.99931,  0.27229,
                           -2.68866, -1.76489, -0.80581,  0.03243,  0.87091,  1.83017,  2.75226,
                           277.9104253,   0.66061,  3.450e-04,
                           -23.1967994,  -0.02279,  1.371e-03,
                           // 2094 12 21
                           2486233.330928,  20.0,   190.7, " 2.514", " 1.463",  1,
                           2.06169,  0.94612,  0.25780,
                           -2.98356, -1.89524, -0.82153, -0.05774,  0.70560,  1.77906,  2.86994,
                           90.5074582,   0.59344, -2.600e-05,
                           23.6187088,   0.04832, -1.148e-03,
                           // 2095  6 17
                           2486411.416791,  22.0,   191.9, " 1.462", " 0.446",  2,
                           15.76352,  0.94810,  0.25834,
                           -2.53594, -1.22017,  0.00000,  0.00299,  0.00000,  1.22863,  2.54210,
                           266.6658029,   0.59635,  5.420e-04,
                           -24.1139197,  -0.06248,  1.131e-03,
                           // 2095 12 11
                           2486587.760439,   6.0,   193.0, " 1.251", " 0.257",  2,
                           11.35035,  0.99890,  0.27218,
                           -2.02369, -0.65842,  0.00000,  0.25053,  0.00000,  1.15727,  2.52457,
                           78.2007824,   0.65432,  2.960e-04,
                           23.8424999,   0.10421, -1.419e-03,
                           // 2096  5  7
                           2486735.975491,  11.0,   193.9, " 0.531", "-0.547",  3,
                           2.08909,  0.89964,  0.24513,
                           -1.39560,  0.00000,  0.00000,  0.41178,  0.00000,  0.00000,  2.21902,
                           225.7410442,   0.47858,  4.430e-04,
                           -16.0204512,  -0.17895,  5.240e-04,
                           // 2096  6  6
                           2486765.613673,   3.0,   194.1, " 0.005", "-1.058",  3,
                           20.03848,  0.90698,  0.24713,
                           -0.44662,  0.00000,  0.00000, -0.27185,  0.00000,  0.00000, -0.09400,
                           255.1419897,   0.53989,  5.100e-04,
                           -24.1644102,  -0.09507,  9.320e-04,
                           // 2096 10 31
                           2486912.979431,  12.0,   195.1, " 0.767", "-0.201",  3,
                           14.72247,  1.01879,  0.27759,
                           -2.32103,  0.00000,  0.00000, -0.49365,  0.00000,  0.00000,  1.33410,
                           37.4675115,   0.59530,  7.400e-04,
                           13.5883506,   0.25233, -6.600e-04,
                           // 2096 11 29
                           2486942.390532,  21.0,   195.2, " 0.086", "-0.882",  3,
                           1.65270,  1.02481,  0.27923,
                           -0.27772,  0.00000,  0.00000,  0.37277,  0.00000,  0.00000,  1.02317,
                           66.3005575,   0.67309,  7.830e-04,
                           23.1731294,   0.15713, -1.433e-03,
                           // 2097  4 26
                           2487090.012697,  12.0,   196.2, " 1.901", " 0.842",  2,
                           2.35311,  0.91795,  0.25012,
                           -2.56194, -1.32228,  0.00000,  0.30473,  0.00000,  1.93045,  3.17168,
                           214.7978108,   0.48142,  2.790e-04,
                           -13.3554599,  -0.21164,  5.170e-04,
                           // 2097 10 21
                           2487267.563138,   2.0,   197.3, " 2.015", " 1.010",  1,
                           4.02208,  0.97717,  0.26625,
                           -3.17754, -2.11109, -0.61100, -0.48469, -0.35745,  1.14271,  2.20671,
                           26.9057902,   0.53207,  6.680e-04,
                           10.6431107,   0.25536, -3.410e-04,
                           // 2098  4 15
                           2487444.294999,  19.0,   198.5, " 2.445", " 1.437",  1,
                           8.63355,  0.96708,  0.26351,
                           -2.73826, -1.71875, -0.66213,  0.07997,  0.82163,  1.87808,  2.90001,
                           204.3203415,   0.51842,  1.970e-04,
                           -10.3487594,  -0.25444,  5.240e-04,
                           // 2098 10 10
                           2487621.888870,   9.0,   199.6, " 2.383", " 1.325",  1,
                           10.30252,  0.92536,  0.25214,
                           -2.64599, -1.50859, -0.35617,  0.33287,  1.02240,  2.17513,  3.31059,
                           15.9934702,   0.46565,  4.040e-04,
                           7.0651998,   0.24311, -1.480e-04,
                           // 2099  4  5
                           2487798.854819,   9.0,   200.7, " 1.133", " 0.168",  2,
                           21.93316,  1.01333,  0.27611,
                           -2.63195, -1.21900,  0.00000, -0.48436,  0.00000,  0.24870,  1.66333,
                           194.4566195,   0.55652,  2.180e-04,
                           -7.2206403,  -0.29161,  4.120e-04,
                           // 2099  9 29
                           2487975.942110,  11.0,   201.9, " 1.034", "-0.051",  3,
                           11.56928,  0.89972,  0.24515,
                           -2.79185,  0.00000,  0.00000, -0.38937,  0.00000,  0.00000,  2.01391,
                           5.8093299,   0.43472,  1.250e-04,
                           3.5221800,   0.23564, -9.400e-05,
                           // 2100  2 24
                           2488124.128604,  15.0,   202.8, " 0.965", "-0.017",  3,
                           1.30528,  1.00695,  0.27437,
                           -1.95177,  0.00000,  0.00000,  0.08650,  0.00000,  0.00000,  2.12513,
                           158.2699494,   0.55927, -3.200e-04,
                           10.2270804,  -0.27870, -5.630e-04,
                           // 2100  8 19
                           2488300.406233,  22.0,   204.0, " 0.872", "-0.158",  3,
                           19.88938,  0.93925,  0.25592,
                           -2.37000,  0.00000,  0.00000, -0.25042,  0.00000,  0.00000,  1.86680,
                           329.8184696,   0.49978, -6.760e-04,
                           -13.3626205,   0.22960,  3.990e-04
                           ));
}
